// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Provisioning state of NetworkSecurityPerimeter configuration propagation. </summary>
    public readonly partial struct EventHubsNetworkSecurityPerimeterConfigurationProvisioningState : IEquatable<EventHubsNetworkSecurityPerimeterConfigurationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsNetworkSecurityPerimeterConfigurationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string AcceptedValue = "Accepted";
        private const string InvalidResponseValue = "InvalidResponse";
        private const string SucceededValue = "Succeeded";
        private const string SucceededWithIssuesValue = "SucceededWithIssues";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string CanceledValue = "Canceled";

        /// <summary> Unknown. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Unknown { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(UnknownValue);
        /// <summary> Creating. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Creating { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Updating { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(UpdatingValue);
        /// <summary> Accepted. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Accepted { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(AcceptedValue);
        /// <summary> InvalidResponse. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState InvalidResponse { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(InvalidResponseValue);
        /// <summary> Succeeded. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Succeeded { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(SucceededValue);
        /// <summary> SucceededWithIssues. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState SucceededWithIssues { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(SucceededWithIssuesValue);
        /// <summary> Failed. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Failed { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Deleting { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Deleted { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(DeletedValue);
        /// <summary> Canceled. </summary>
        public static EventHubsNetworkSecurityPerimeterConfigurationProvisioningState Canceled { get; } = new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="EventHubsNetworkSecurityPerimeterConfigurationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(EventHubsNetworkSecurityPerimeterConfigurationProvisioningState left, EventHubsNetworkSecurityPerimeterConfigurationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsNetworkSecurityPerimeterConfigurationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(EventHubsNetworkSecurityPerimeterConfigurationProvisioningState left, EventHubsNetworkSecurityPerimeterConfigurationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsNetworkSecurityPerimeterConfigurationProvisioningState"/>. </summary>
        public static implicit operator EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(string value) => new EventHubsNetworkSecurityPerimeterConfigurationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsNetworkSecurityPerimeterConfigurationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsNetworkSecurityPerimeterConfigurationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
