// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Network Security Perimeter related configurations of a given namespace. </summary>
    public partial class EventHubsNetworkSecurityPerimeterConfiguration : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventHubsNetworkSecurityPerimeterConfiguration"/>. </summary>
        public EventHubsNetworkSecurityPerimeterConfiguration()
        {
            ProvisioningIssues = new ChangeTrackingList<EventHubsProvisioningIssue>();
            ApplicableFeatures = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="EventHubsNetworkSecurityPerimeterConfiguration"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning state of NetworkSecurityPerimeter configuration propagation. </param>
        /// <param name="provisioningIssues"> List of Provisioning Issues if any. </param>
        /// <param name="networkSecurityPerimeter"> NetworkSecurityPerimeter related information. </param>
        /// <param name="resourceAssociation"> Information about resource association. </param>
        /// <param name="profile"> Information about current network profile. </param>
        /// <param name="isBackingResource"> True if the EventHub namespace is backed by another Azure resource and not visible to end users. </param>
        /// <param name="applicableFeatures"> Indicates that the NSP controls related to backing association are only applicable to a specific feature in backing resource's data plane. </param>
        /// <param name="parentAssociationName"> Source Resource Association name. </param>
        /// <param name="sourceResourceId"> ARM Id of source resource. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventHubsNetworkSecurityPerimeterConfiguration(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, EventHubsNetworkSecurityPerimeterConfigurationProvisioningState? provisioningState, IList<EventHubsProvisioningIssue> provisioningIssues, EventHubsNetworkSecurityPerimeter networkSecurityPerimeter, EventHubsNetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation, EventHubsNetworkSecurityPerimeterConfigurationPropertiesProfile profile, bool? isBackingResource, IReadOnlyList<string> applicableFeatures, string parentAssociationName, ResourceIdentifier sourceResourceId, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            ProvisioningIssues = provisioningIssues;
            NetworkSecurityPerimeter = networkSecurityPerimeter;
            ResourceAssociation = resourceAssociation;
            Profile = profile;
            IsBackingResource = isBackingResource;
            ApplicableFeatures = applicableFeatures;
            ParentAssociationName = parentAssociationName;
            SourceResourceId = sourceResourceId;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Provisioning state of NetworkSecurityPerimeter configuration propagation. </summary>
        [WirePath("properties.provisioningState")]
        public EventHubsNetworkSecurityPerimeterConfigurationProvisioningState? ProvisioningState { get; set; }
        /// <summary> List of Provisioning Issues if any. </summary>
        [WirePath("properties.provisioningIssues")]
        public IList<EventHubsProvisioningIssue> ProvisioningIssues { get; }
        /// <summary> NetworkSecurityPerimeter related information. </summary>
        [WirePath("properties.networkSecurityPerimeter")]
        public EventHubsNetworkSecurityPerimeter NetworkSecurityPerimeter { get; }
        /// <summary> Information about resource association. </summary>
        [WirePath("properties.resourceAssociation")]
        public EventHubsNetworkSecurityPerimeterConfigurationPropertiesResourceAssociation ResourceAssociation { get; }
        /// <summary> Information about current network profile. </summary>
        [WirePath("properties.profile")]
        public EventHubsNetworkSecurityPerimeterConfigurationPropertiesProfile Profile { get; }
        /// <summary> True if the EventHub namespace is backed by another Azure resource and not visible to end users. </summary>
        [WirePath("properties.isBackingResource")]
        public bool? IsBackingResource { get; }
        /// <summary> Indicates that the NSP controls related to backing association are only applicable to a specific feature in backing resource's data plane. </summary>
        [WirePath("properties.applicableFeatures")]
        public IReadOnlyList<string> ApplicableFeatures { get; }
        /// <summary> Source Resource Association name. </summary>
        [WirePath("properties.parentAssociationName")]
        public string ParentAssociationName { get; }
        /// <summary> ARM Id of source resource. </summary>
        [WirePath("properties.sourceResourceId")]
        public ResourceIdentifier SourceResourceId { get; }
        /// <summary> The geo-location where the resource lives. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
    }
}
