// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Default Action for Network Rule Set. </summary>
    public readonly partial struct EventHubsNetworkRuleSetDefaultAction : IEquatable<EventHubsNetworkRuleSetDefaultAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsNetworkRuleSetDefaultAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsNetworkRuleSetDefaultAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static EventHubsNetworkRuleSetDefaultAction Allow { get; } = new EventHubsNetworkRuleSetDefaultAction(AllowValue);
        /// <summary> Deny. </summary>
        public static EventHubsNetworkRuleSetDefaultAction Deny { get; } = new EventHubsNetworkRuleSetDefaultAction(DenyValue);
        /// <summary> Determines if two <see cref="EventHubsNetworkRuleSetDefaultAction"/> values are the same. </summary>
        public static bool operator ==(EventHubsNetworkRuleSetDefaultAction left, EventHubsNetworkRuleSetDefaultAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsNetworkRuleSetDefaultAction"/> values are not the same. </summary>
        public static bool operator !=(EventHubsNetworkRuleSetDefaultAction left, EventHubsNetworkRuleSetDefaultAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsNetworkRuleSetDefaultAction"/>. </summary>
        public static implicit operator EventHubsNetworkRuleSetDefaultAction(string value) => new EventHubsNetworkRuleSetDefaultAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsNetworkRuleSetDefaultAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsNetworkRuleSetDefaultAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
