// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.EventHubs.Models
{
    internal static partial class EventHubsNameUnavailableReasonExtensions
    {
        public static string ToSerialString(this EventHubsNameUnavailableReason value) => value switch
        {
            EventHubsNameUnavailableReason.None => "None",
            EventHubsNameUnavailableReason.InvalidName => "InvalidName",
            EventHubsNameUnavailableReason.SubscriptionIsDisabled => "SubscriptionIsDisabled",
            EventHubsNameUnavailableReason.NameInUse => "NameInUse",
            EventHubsNameUnavailableReason.NameInLockdown => "NameInLockdown",
            EventHubsNameUnavailableReason.TooManyNamespaceInCurrentSubscription => "TooManyNamespaceInCurrentSubscription",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EventHubsNameUnavailableReason value.")
        };

        public static EventHubsNameUnavailableReason ToEventHubsNameUnavailableReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return EventHubsNameUnavailableReason.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InvalidName")) return EventHubsNameUnavailableReason.InvalidName;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SubscriptionIsDisabled")) return EventHubsNameUnavailableReason.SubscriptionIsDisabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NameInUse")) return EventHubsNameUnavailableReason.NameInUse;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NameInLockdown")) return EventHubsNameUnavailableReason.NameInLockdown;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TooManyNamespaceInCurrentSubscription")) return EventHubsNameUnavailableReason.TooManyNamespaceInCurrentSubscription;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EventHubsNameUnavailableReason value.");
        }
    }
}
