// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Properties to configure keyVault Properties. </summary>
    public partial class EventHubsKeyVaultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventHubsKeyVaultProperties"/>. </summary>
        public EventHubsKeyVaultProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventHubsKeyVaultProperties"/>. </summary>
        /// <param name="keyName"> Name of the Key from KeyVault. </param>
        /// <param name="keyVaultUri"> Uri of KeyVault. </param>
        /// <param name="keyVersion"> Key Version. </param>
        /// <param name="identity"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventHubsKeyVaultProperties(string keyName, Uri keyVaultUri, string keyVersion, UserAssignedIdentityProperties identity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            KeyVaultUri = keyVaultUri;
            KeyVersion = keyVersion;
            Identity = identity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the Key from KeyVault. </summary>
        [WirePath("keyName")]
        public string KeyName { get; set; }
        /// <summary> Uri of KeyVault. </summary>
        [WirePath("keyVaultUri")]
        public Uri KeyVaultUri { get; set; }
        /// <summary> Key Version. </summary>
        [WirePath("keyVersion")]
        public string KeyVersion { get; set; }
        /// <summary> Gets or sets the identity. </summary>
        internal UserAssignedIdentityProperties Identity { get; set; }
        /// <summary> ARM ID of user Identity selected for encryption. </summary>
        [WirePath("identity.userAssignedIdentity")]
        public string UserAssignedIdentity
        {
            get => Identity is null ? default : Identity.UserAssignedIdentity;
            set
            {
                if (Identity is null)
                    Identity = new UserAssignedIdentityProperties();
                Identity.UserAssignedIdentity = value;
            }
        }
    }
}
