// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Enumerates the possible value of keySource for Encryption. </summary>
    public readonly partial struct EventHubsKeySource : IEquatable<EventHubsKeySource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsKeySource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsKeySource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftKeyVaultValue = "Microsoft.KeyVault";

        /// <summary> Microsoft.KeyVault. </summary>
        public static EventHubsKeySource MicrosoftKeyVault { get; } = new EventHubsKeySource(MicrosoftKeyVaultValue);
        /// <summary> Determines if two <see cref="EventHubsKeySource"/> values are the same. </summary>
        public static bool operator ==(EventHubsKeySource left, EventHubsKeySource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsKeySource"/> values are not the same. </summary>
        public static bool operator !=(EventHubsKeySource left, EventHubsKeySource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsKeySource"/>. </summary>
        public static implicit operator EventHubsKeySource(string value) => new EventHubsKeySource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsKeySource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsKeySource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
