// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.EventHubs.Models
{
    internal static partial class EventHubsDisasterRecoveryRoleExtensions
    {
        public static string ToSerialString(this EventHubsDisasterRecoveryRole value) => value switch
        {
            EventHubsDisasterRecoveryRole.Primary => "Primary",
            EventHubsDisasterRecoveryRole.PrimaryNotReplicating => "PrimaryNotReplicating",
            EventHubsDisasterRecoveryRole.Secondary => "Secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EventHubsDisasterRecoveryRole value.")
        };

        public static EventHubsDisasterRecoveryRole ToEventHubsDisasterRecoveryRole(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return EventHubsDisasterRecoveryRole.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PrimaryNotReplicating")) return EventHubsDisasterRecoveryRole.PrimaryNotReplicating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return EventHubsDisasterRecoveryRole.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EventHubsDisasterRecoveryRole value.");
        }
    }
}
