// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Name of this SKU. </summary>
    public readonly partial struct EventHubsClusterSkuName : IEquatable<EventHubsClusterSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsClusterSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsClusterSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DedicatedValue = "Dedicated";

        /// <summary> Dedicated. </summary>
        public static EventHubsClusterSkuName Dedicated { get; } = new EventHubsClusterSkuName(DedicatedValue);
        /// <summary> Determines if two <see cref="EventHubsClusterSkuName"/> values are the same. </summary>
        public static bool operator ==(EventHubsClusterSkuName left, EventHubsClusterSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsClusterSkuName"/> values are not the same. </summary>
        public static bool operator !=(EventHubsClusterSkuName left, EventHubsClusterSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsClusterSkuName"/>. </summary>
        public static implicit operator EventHubsClusterSkuName(string value) => new EventHubsClusterSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsClusterSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsClusterSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
