// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> SKU parameters particular to a cluster instance. </summary>
    public partial class EventHubsClusterSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventHubsClusterSku"/>. </summary>
        /// <param name="name"> Name of this SKU. </param>
        public EventHubsClusterSku(EventHubsClusterSkuName name)
        {
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="EventHubsClusterSku"/>. </summary>
        /// <param name="name"> Name of this SKU. </param>
        /// <param name="capacity"> The quantity of Event Hubs Cluster Capacity Units contained in this cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventHubsClusterSku(EventHubsClusterSkuName name, int? capacity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Capacity = capacity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EventHubsClusterSku"/> for deserialization. </summary>
        internal EventHubsClusterSku()
        {
        }

        /// <summary> Name of this SKU. </summary>
        [WirePath("name")]
        public EventHubsClusterSkuName Name { get; set; }
        /// <summary> The quantity of Event Hubs Cluster Capacity Units contained in this cluster. </summary>
        [WirePath("capacity")]
        public int? Capacity { get; set; }
    }
}
