// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Provisioning state of the Cluster. </summary>
    public readonly partial struct EventHubsClusterProvisioningState : IEquatable<EventHubsClusterProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsClusterProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsClusterProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string ScalingValue = "Scaling";
        private const string ActiveValue = "Active";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";

        /// <summary> Unknown. </summary>
        public static EventHubsClusterProvisioningState Unknown { get; } = new EventHubsClusterProvisioningState(UnknownValue);
        /// <summary> Creating. </summary>
        public static EventHubsClusterProvisioningState Creating { get; } = new EventHubsClusterProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static EventHubsClusterProvisioningState Deleting { get; } = new EventHubsClusterProvisioningState(DeletingValue);
        /// <summary> Scaling. </summary>
        public static EventHubsClusterProvisioningState Scaling { get; } = new EventHubsClusterProvisioningState(ScalingValue);
        /// <summary> Active. </summary>
        public static EventHubsClusterProvisioningState Active { get; } = new EventHubsClusterProvisioningState(ActiveValue);
        /// <summary> Failed. </summary>
        public static EventHubsClusterProvisioningState Failed { get; } = new EventHubsClusterProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static EventHubsClusterProvisioningState Succeeded { get; } = new EventHubsClusterProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static EventHubsClusterProvisioningState Canceled { get; } = new EventHubsClusterProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="EventHubsClusterProvisioningState"/> values are the same. </summary>
        public static bool operator ==(EventHubsClusterProvisioningState left, EventHubsClusterProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsClusterProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(EventHubsClusterProvisioningState left, EventHubsClusterProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsClusterProvisioningState"/>. </summary>
        public static implicit operator EventHubsClusterProvisioningState(string value) => new EventHubsClusterProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsClusterProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsClusterProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
