// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.EventHubs.Models
{
    internal static partial class EventHubsCaptureIdentityTypeExtensions
    {
        public static string ToSerialString(this EventHubsCaptureIdentityType value) => value switch
        {
            EventHubsCaptureIdentityType.SystemAssigned => "SystemAssigned",
            EventHubsCaptureIdentityType.UserAssigned => "UserAssigned",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EventHubsCaptureIdentityType value.")
        };

        public static EventHubsCaptureIdentityType ToEventHubsCaptureIdentityType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SystemAssigned")) return EventHubsCaptureIdentityType.SystemAssigned;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UserAssigned")) return EventHubsCaptureIdentityType.UserAssigned;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EventHubsCaptureIdentityType value.");
        }
    }
}
