// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> The EventHubsAccessRight. </summary>
    public readonly partial struct EventHubsAccessRight : IEquatable<EventHubsAccessRight>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsAccessRight"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsAccessRight(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManageValue = "Manage";
        private const string SendValue = "Send";
        private const string ListenValue = "Listen";

        /// <summary> Manage. </summary>
        public static EventHubsAccessRight Manage { get; } = new EventHubsAccessRight(ManageValue);
        /// <summary> Send. </summary>
        public static EventHubsAccessRight Send { get; } = new EventHubsAccessRight(SendValue);
        /// <summary> Listen. </summary>
        public static EventHubsAccessRight Listen { get; } = new EventHubsAccessRight(ListenValue);
        /// <summary> Determines if two <see cref="EventHubsAccessRight"/> values are the same. </summary>
        public static bool operator ==(EventHubsAccessRight left, EventHubsAccessRight right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsAccessRight"/> values are not the same. </summary>
        public static bool operator !=(EventHubsAccessRight left, EventHubsAccessRight right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsAccessRight"/>. </summary>
        public static implicit operator EventHubsAccessRight(string value) => new EventHubsAccessRight(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsAccessRight other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsAccessRight other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
