// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> The access key to regenerate. </summary>
    public readonly partial struct EventHubsAccessKeyType : IEquatable<EventHubsAccessKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsAccessKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsAccessKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryKeyValue = "PrimaryKey";
        private const string SecondaryKeyValue = "SecondaryKey";

        /// <summary> PrimaryKey. </summary>
        public static EventHubsAccessKeyType PrimaryKey { get; } = new EventHubsAccessKeyType(PrimaryKeyValue);
        /// <summary> SecondaryKey. </summary>
        public static EventHubsAccessKeyType SecondaryKey { get; } = new EventHubsAccessKeyType(SecondaryKeyValue);
        /// <summary> Determines if two <see cref="EventHubsAccessKeyType"/> values are the same. </summary>
        public static bool operator ==(EventHubsAccessKeyType left, EventHubsAccessKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsAccessKeyType"/> values are not the same. </summary>
        public static bool operator !=(EventHubsAccessKeyType left, EventHubsAccessKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsAccessKeyType"/>. </summary>
        public static implicit operator EventHubsAccessKeyType(string value) => new EventHubsAccessKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsAccessKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsAccessKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
