// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventHubs.Models
{
    public partial class EventHubDestination : IUtf8JsonSerializable, IJsonModel<EventHubDestination>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EventHubDestination>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EventHubDestination>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EventHubDestination>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EventHubDestination)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                writer.WriteObjectValue(Identity, options);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(StorageAccountResourceId))
            {
                writer.WritePropertyName("storageAccountResourceId"u8);
                writer.WriteStringValue(StorageAccountResourceId);
            }
            if (Optional.IsDefined(BlobContainer))
            {
                writer.WritePropertyName("blobContainer"u8);
                writer.WriteStringValue(BlobContainer);
            }
            if (Optional.IsDefined(ArchiveNameFormat))
            {
                writer.WritePropertyName("archiveNameFormat"u8);
                writer.WriteStringValue(ArchiveNameFormat);
            }
            if (Optional.IsDefined(DataLakeSubscriptionId))
            {
                writer.WritePropertyName("dataLakeSubscriptionId"u8);
                writer.WriteStringValue(DataLakeSubscriptionId.Value);
            }
            if (Optional.IsDefined(DataLakeAccountName))
            {
                writer.WritePropertyName("dataLakeAccountName"u8);
                writer.WriteStringValue(DataLakeAccountName);
            }
            if (Optional.IsDefined(DataLakeFolderPath))
            {
                writer.WritePropertyName("dataLakeFolderPath"u8);
                writer.WriteStringValue(DataLakeFolderPath);
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EventHubDestination IJsonModel<EventHubDestination>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EventHubDestination>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EventHubDestination)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEventHubDestination(document.RootElement, options);
        }

        internal static EventHubDestination DeserializeEventHubDestination(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            EventHubsCaptureIdentity identity = default;
            ResourceIdentifier storageAccountResourceId = default;
            string blobContainer = default;
            string archiveNameFormat = default;
            Guid? dataLakeSubscriptionId = default;
            string dataLakeAccountName = default;
            string dataLakeFolderPath = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = EventHubsCaptureIdentity.DeserializeEventHubsCaptureIdentity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("storageAccountResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            storageAccountResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("blobContainer"u8))
                        {
                            blobContainer = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("archiveNameFormat"u8))
                        {
                            archiveNameFormat = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("dataLakeSubscriptionId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dataLakeSubscriptionId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("dataLakeAccountName"u8))
                        {
                            dataLakeAccountName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("dataLakeFolderPath"u8))
                        {
                            dataLakeFolderPath = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EventHubDestination(
                name,
                identity,
                storageAccountResourceId,
                blobContainer,
                archiveNameFormat,
                dataLakeSubscriptionId,
                dataLakeAccountName,
                dataLakeFolderPath,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Identity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Identity))
                {
                    builder.Append("  identity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Identity, options, 2, false, "  identity: ");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageAccountResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    storageAccountResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StorageAccountResourceId))
                {
                    builder.Append("    storageAccountResourceId: ");
                    builder.AppendLine($"'{StorageAccountResourceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BlobContainer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    blobContainer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BlobContainer))
                {
                    builder.Append("    blobContainer: ");
                    if (BlobContainer.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BlobContainer}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BlobContainer}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ArchiveNameFormat), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    archiveNameFormat: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ArchiveNameFormat))
                {
                    builder.Append("    archiveNameFormat: ");
                    if (ArchiveNameFormat.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ArchiveNameFormat}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ArchiveNameFormat}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataLakeSubscriptionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dataLakeSubscriptionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataLakeSubscriptionId))
                {
                    builder.Append("    dataLakeSubscriptionId: ");
                    builder.AppendLine($"'{DataLakeSubscriptionId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataLakeAccountName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dataLakeAccountName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataLakeAccountName))
                {
                    builder.Append("    dataLakeAccountName: ");
                    if (DataLakeAccountName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DataLakeAccountName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DataLakeAccountName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataLakeFolderPath), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dataLakeFolderPath: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataLakeFolderPath))
                {
                    builder.Append("    dataLakeFolderPath: ");
                    if (DataLakeFolderPath.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DataLakeFolderPath}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DataLakeFolderPath}'");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<EventHubDestination>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EventHubDestination>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(EventHubDestination)} does not support writing '{options.Format}' format.");
            }
        }

        EventHubDestination IPersistableModel<EventHubDestination>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EventHubDestination>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEventHubDestination(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EventHubDestination)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EventHubDestination>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
