// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventHubs
{
    internal class EventHubsNamespaceOperationSource : IOperationSource<EventHubsNamespaceResource>
    {
        private readonly ArmClient _client;

        internal EventHubsNamespaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        EventHubsNamespaceResource IOperationSource<EventHubsNamespaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EventHubsNamespaceData.DeserializeEventHubsNamespaceData(document.RootElement);
            return new EventHubsNamespaceResource(_client, data);
        }

        async ValueTask<EventHubsNamespaceResource> IOperationSource<EventHubsNamespaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EventHubsNamespaceData.DeserializeEventHubsNamespaceData(document.RootElement);
            return new EventHubsNamespaceResource(_client, data);
        }
    }
}
