// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventHubs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventHubs
{
    /// <summary>
    /// A class representing the EventHubsSchemaGroup data model.
    /// Single item in List or Get Schema Group operation
    /// </summary>
    public partial class EventHubsSchemaGroupData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventHubsSchemaGroupData"/>. </summary>
        public EventHubsSchemaGroupData()
        {
            GroupProperties = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="EventHubsSchemaGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="updatedAtUtc"> Exact time the Schema Group was updated. </param>
        /// <param name="createdAtUtc"> Exact time the Schema Group was created. </param>
        /// <param name="eTag"> The ETag value. </param>
        /// <param name="groupProperties"> dictionary object for SchemaGroup group properties. </param>
        /// <param name="schemaCompatibility"></param>
        /// <param name="schemaType"></param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventHubsSchemaGroupData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? updatedAtUtc, DateTimeOffset? createdAtUtc, ETag? eTag, IDictionary<string, string> groupProperties, EventHubsSchemaCompatibility? schemaCompatibility, EventHubsSchemaType? schemaType, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            UpdatedAtUtc = updatedAtUtc;
            CreatedAtUtc = createdAtUtc;
            ETag = eTag;
            GroupProperties = groupProperties;
            SchemaCompatibility = schemaCompatibility;
            SchemaType = schemaType;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Exact time the Schema Group was updated. </summary>
        [WirePath("properties.updatedAtUtc")]
        public DateTimeOffset? UpdatedAtUtc { get; }
        /// <summary> Exact time the Schema Group was created. </summary>
        [WirePath("properties.createdAtUtc")]
        public DateTimeOffset? CreatedAtUtc { get; }
        /// <summary> The ETag value. </summary>
        [WirePath("properties.eTag")]
        public ETag? ETag { get; }
        /// <summary> dictionary object for SchemaGroup group properties. </summary>
        [WirePath("properties.groupProperties")]
        public IDictionary<string, string> GroupProperties { get; }
        /// <summary> Gets or sets the schema compatibility. </summary>
        [WirePath("properties.schemaCompatibility")]
        public EventHubsSchemaCompatibility? SchemaCompatibility { get; set; }
        /// <summary> Gets or sets the schema type. </summary>
        [WirePath("properties.schemaType")]
        public EventHubsSchemaType? SchemaType { get; set; }
        /// <summary> The geo-location where the resource lives. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
    }
}
