// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventHubs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventHubs
{
    /// <summary>
    /// A class representing the EventHub data model.
    /// Single item in List or Get Event Hub operation
    /// </summary>
    public partial class EventHubData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventHubData"/>. </summary>
        public EventHubData()
        {
            PartitionIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="EventHubData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="partitionIds"> Current number of shards on the Event Hub. </param>
        /// <param name="createdOn"> Exact time the Event Hub was created. </param>
        /// <param name="updatedOn"> The exact time the message was updated. </param>
        /// <param name="partitionCount"> Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions. </param>
        /// <param name="status"> Enumerates the possible values for the status of the Event Hub. </param>
        /// <param name="userMetadata"> Gets and Sets Metadata of User. </param>
        /// <param name="captureDescription"> Properties of capture description. </param>
        /// <param name="retentionDescription"> Event Hub retention settings. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventHubData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IReadOnlyList<string> partitionIds, DateTimeOffset? createdOn, DateTimeOffset? updatedOn, long? partitionCount, EventHubEntityStatus? status, string userMetadata, CaptureDescription captureDescription, RetentionDescription retentionDescription, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PartitionIds = partitionIds;
            CreatedOn = createdOn;
            UpdatedOn = updatedOn;
            PartitionCount = partitionCount;
            Status = status;
            UserMetadata = userMetadata;
            CaptureDescription = captureDescription;
            RetentionDescription = retentionDescription;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current number of shards on the Event Hub. </summary>
        [WirePath("properties.partitionIds")]
        public IReadOnlyList<string> PartitionIds { get; }
        /// <summary> Exact time the Event Hub was created. </summary>
        [WirePath("properties.createdAt")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The exact time the message was updated. </summary>
        [WirePath("properties.updatedAt")]
        public DateTimeOffset? UpdatedOn { get; }
        /// <summary> Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions. </summary>
        [WirePath("properties.partitionCount")]
        public long? PartitionCount { get; set; }
        /// <summary> Enumerates the possible values for the status of the Event Hub. </summary>
        [WirePath("properties.status")]
        public EventHubEntityStatus? Status { get; set; }
        /// <summary> Gets and Sets Metadata of User. </summary>
        [WirePath("properties.userMetadata")]
        public string UserMetadata { get; set; }
        /// <summary> Properties of capture description. </summary>
        [WirePath("properties.captureDescription")]
        public CaptureDescription CaptureDescription { get; set; }
        /// <summary> Event Hub retention settings. </summary>
        [WirePath("properties.retentionDescription")]
        public RetentionDescription RetentionDescription { get; set; }
        /// <summary> The geo-location where the resource lives. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
    }
}
