// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.EventHubs.Models;

namespace Azure.ResourceManager.EventHubs.Samples
{
    public partial class Sample_EventHubsSchemaGroupCollection
    {
        // SchemaRegistryListAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_SchemaRegistryListAll()
        {
            // Generated from example definition: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/SchemaRegistry/SchemaRegistryListByNamespace.json
            // this example is just showing the usage of "SchemaRegistry_ListByNamespace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubsNamespaceResource created on azure
            // for more information of creating EventHubsNamespaceResource, please refer to the document of EventHubsNamespaceResource
            string subscriptionId = "e8baea74-64ce-459b-bee3-5aa4c47b3ae3";
            string resourceGroupName = "alitest";
            string namespaceName = "ali-ua-test-eh-system-1";
            ResourceIdentifier eventHubsNamespaceResourceId = EventHubsNamespaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName);
            EventHubsNamespaceResource eventHubsNamespace = client.GetEventHubsNamespaceResource(eventHubsNamespaceResourceId);

            // get the collection of this EventHubsSchemaGroupResource
            EventHubsSchemaGroupCollection collection = eventHubsNamespace.GetEventHubsSchemaGroups();

            // invoke the operation and iterate over the result
            await foreach (EventHubsSchemaGroupResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                EventHubsSchemaGroupData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // SchemaRegistryCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SchemaRegistryCreate()
        {
            // Generated from example definition: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/SchemaRegistry/SchemaRegistryCreate.json
            // this example is just showing the usage of "SchemaRegistry_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubsNamespaceResource created on azure
            // for more information of creating EventHubsNamespaceResource, please refer to the document of EventHubsNamespaceResource
            string subscriptionId = "e8baea74-64ce-459b-bee3-5aa4c47b3ae3";
            string resourceGroupName = "alitest";
            string namespaceName = "ali-ua-test-eh-system-1";
            ResourceIdentifier eventHubsNamespaceResourceId = EventHubsNamespaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName);
            EventHubsNamespaceResource eventHubsNamespace = client.GetEventHubsNamespaceResource(eventHubsNamespaceResourceId);

            // get the collection of this EventHubsSchemaGroupResource
            EventHubsSchemaGroupCollection collection = eventHubsNamespace.GetEventHubsSchemaGroups();

            // invoke the operation
            string schemaGroupName = "testSchemaGroup1";
            EventHubsSchemaGroupData data = new EventHubsSchemaGroupData()
            {
                GroupProperties =
{
},
                SchemaCompatibility = EventHubsSchemaCompatibility.Forward,
                SchemaType = EventHubsSchemaType.Avro,
            };
            ArmOperation<EventHubsSchemaGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, schemaGroupName, data);
            EventHubsSchemaGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventHubsSchemaGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SchemaRegistryGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SchemaRegistryGet()
        {
            // Generated from example definition: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/SchemaRegistry/SchemaRegistryGet.json
            // this example is just showing the usage of "SchemaRegistry_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubsNamespaceResource created on azure
            // for more information of creating EventHubsNamespaceResource, please refer to the document of EventHubsNamespaceResource
            string subscriptionId = "e8baea74-64ce-459b-bee3-5aa4c47b3ae3";
            string resourceGroupName = "alitest";
            string namespaceName = "ali-ua-test-eh-system-1";
            ResourceIdentifier eventHubsNamespaceResourceId = EventHubsNamespaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName);
            EventHubsNamespaceResource eventHubsNamespace = client.GetEventHubsNamespaceResource(eventHubsNamespaceResourceId);

            // get the collection of this EventHubsSchemaGroupResource
            EventHubsSchemaGroupCollection collection = eventHubsNamespace.GetEventHubsSchemaGroups();

            // invoke the operation
            string schemaGroupName = "testSchemaGroup1";
            EventHubsSchemaGroupResource result = await collection.GetAsync(schemaGroupName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventHubsSchemaGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SchemaRegistryGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SchemaRegistryGet()
        {
            // Generated from example definition: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/SchemaRegistry/SchemaRegistryGet.json
            // this example is just showing the usage of "SchemaRegistry_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubsNamespaceResource created on azure
            // for more information of creating EventHubsNamespaceResource, please refer to the document of EventHubsNamespaceResource
            string subscriptionId = "e8baea74-64ce-459b-bee3-5aa4c47b3ae3";
            string resourceGroupName = "alitest";
            string namespaceName = "ali-ua-test-eh-system-1";
            ResourceIdentifier eventHubsNamespaceResourceId = EventHubsNamespaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName);
            EventHubsNamespaceResource eventHubsNamespace = client.GetEventHubsNamespaceResource(eventHubsNamespaceResourceId);

            // get the collection of this EventHubsSchemaGroupResource
            EventHubsSchemaGroupCollection collection = eventHubsNamespace.GetEventHubsSchemaGroups();

            // invoke the operation
            string schemaGroupName = "testSchemaGroup1";
            bool result = await collection.ExistsAsync(schemaGroupName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // SchemaRegistryGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SchemaRegistryGet()
        {
            // Generated from example definition: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/SchemaRegistry/SchemaRegistryGet.json
            // this example is just showing the usage of "SchemaRegistry_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubsNamespaceResource created on azure
            // for more information of creating EventHubsNamespaceResource, please refer to the document of EventHubsNamespaceResource
            string subscriptionId = "e8baea74-64ce-459b-bee3-5aa4c47b3ae3";
            string resourceGroupName = "alitest";
            string namespaceName = "ali-ua-test-eh-system-1";
            ResourceIdentifier eventHubsNamespaceResourceId = EventHubsNamespaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName);
            EventHubsNamespaceResource eventHubsNamespace = client.GetEventHubsNamespaceResource(eventHubsNamespaceResourceId);

            // get the collection of this EventHubsSchemaGroupResource
            EventHubsSchemaGroupCollection collection = eventHubsNamespace.GetEventHubsSchemaGroups();

            // invoke the operation
            string schemaGroupName = "testSchemaGroup1";
            NullableResponse<EventHubsSchemaGroupResource> response = await collection.GetIfExistsAsync(schemaGroupName);
            EventHubsSchemaGroupResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                EventHubsSchemaGroupData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
