// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.EventHubs.Models;

namespace Azure.ResourceManager.EventHubs.Samples
{
    public partial class Sample_EventHubsDisasterRecoveryAuthorizationRuleResource
    {
        // NameSpaceAuthorizationRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_NameSpaceAuthorizationRuleGet()
        {
            // Generated from example definition: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/disasterRecoveryConfigs/EHAliasAuthorizationRuleGet.json
            // this example is just showing the usage of "DisasterRecoveryConfigs_GetAuthorizationRule" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubsDisasterRecoveryAuthorizationRuleResource created on azure
            // for more information of creating EventHubsDisasterRecoveryAuthorizationRuleResource, please refer to the document of EventHubsDisasterRecoveryAuthorizationRuleResource
            string subscriptionId = "exampleSubscriptionId";
            string resourceGroupName = "exampleResourceGroup";
            string namespaceName = "sdk-Namespace-9080";
            string @alias = "sdk-DisasterRecovery-4879";
            string authorizationRuleName = "sdk-Authrules-4879";
            ResourceIdentifier eventHubsDisasterRecoveryAuthorizationRuleResourceId = EventHubsDisasterRecoveryAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, @alias, authorizationRuleName);
            EventHubsDisasterRecoveryAuthorizationRuleResource eventHubsDisasterRecoveryAuthorizationRule = client.GetEventHubsDisasterRecoveryAuthorizationRuleResource(eventHubsDisasterRecoveryAuthorizationRuleResourceId);

            // invoke the operation
            EventHubsDisasterRecoveryAuthorizationRuleResource result = await eventHubsDisasterRecoveryAuthorizationRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventHubsAuthorizationRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // NameSpaceAuthorizationRuleListKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_NameSpaceAuthorizationRuleListKey()
        {
            // Generated from example definition: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/disasterRecoveryConfigs/EHAliasAuthorizationRuleListKey.json
            // this example is just showing the usage of "DisasterRecoveryConfigs_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubsDisasterRecoveryAuthorizationRuleResource created on azure
            // for more information of creating EventHubsDisasterRecoveryAuthorizationRuleResource, please refer to the document of EventHubsDisasterRecoveryAuthorizationRuleResource
            string subscriptionId = "exampleSubscriptionId";
            string resourceGroupName = "exampleResourceGroup";
            string namespaceName = "sdk-Namespace-2702";
            string @alias = "sdk-DisasterRecovery-4047";
            string authorizationRuleName = "sdk-Authrules-1746";
            ResourceIdentifier eventHubsDisasterRecoveryAuthorizationRuleResourceId = EventHubsDisasterRecoveryAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, @alias, authorizationRuleName);
            EventHubsDisasterRecoveryAuthorizationRuleResource eventHubsDisasterRecoveryAuthorizationRule = client.GetEventHubsDisasterRecoveryAuthorizationRuleResource(eventHubsDisasterRecoveryAuthorizationRuleResourceId);

            // invoke the operation
            EventHubsAccessKeys result = await eventHubsDisasterRecoveryAuthorizationRule.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
