// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventGrid.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventGrid
{
    /// <summary>
    /// A class representing the SystemTopic data model.
    /// EventGrid System Topic.
    /// </summary>
    public partial class SystemTopicData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SystemTopicData"/>. </summary>
        /// <param name="location"> The location. </param>
        public SystemTopicData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="SystemTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity information for the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the system topic. </param>
        /// <param name="source"> Source for the system topic. </param>
        /// <param name="topicType"> TopicType for the system topic. </param>
        /// <param name="metricResourceId"> Metric resource id for the system topic. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SystemTopicData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, EventGridResourceProvisioningState? provisioningState, ResourceIdentifier source, string topicType, Guid? metricResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            ProvisioningState = provisioningState;
            Source = source;
            TopicType = topicType;
            MetricResourceId = metricResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SystemTopicData"/> for deserialization. </summary>
        internal SystemTopicData()
        {
        }

        /// <summary> Identity information for the resource. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> Provisioning state of the system topic. </summary>
        [WirePath("properties.provisioningState")]
        public EventGridResourceProvisioningState? ProvisioningState { get; }
        /// <summary> Source for the system topic. </summary>
        [WirePath("properties.source")]
        public ResourceIdentifier Source { get; set; }
        /// <summary> TopicType for the system topic. </summary>
        [WirePath("properties.topicType")]
        public string TopicType { get; set; }
        /// <summary> Metric resource id for the system topic. </summary>
        [WirePath("properties.metricResourceId")]
        public Guid? MetricResourceId { get; }
    }
}
