// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventGrid.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventGrid
{
    /// <summary>
    /// A class representing the PartnerTopic data model.
    /// Event Grid Partner Topic.
    /// </summary>
    public partial class PartnerTopicData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerTopicData"/>. </summary>
        /// <param name="location"> The location. </param>
        public PartnerTopicData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="PartnerTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity information for the Partner Topic resource. </param>
        /// <param name="partnerRegistrationImmutableId"> The immutableId of the corresponding partner registration. </param>
        /// <param name="source"> Source associated with this partner topic. This represents a unique partner resource. </param>
        /// <param name="eventTypeInfo"> Event Type information from the corresponding event channel. </param>
        /// <param name="expireOnIfNotActivated">
        /// Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
        /// the partner topic and corresponding event channel are deleted.
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the partner topic. </param>
        /// <param name="activationState"> Activation state of the partner topic. </param>
        /// <param name="partnerTopicFriendlyDescription">
        /// Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
        /// This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
        /// </param>
        /// <param name="messageForActivation"> Context or helpful message that can be used during the approval process by the subscriber. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerTopicData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, Guid? partnerRegistrationImmutableId, string source, PartnerTopicEventTypeInfo eventTypeInfo, DateTimeOffset? expireOnIfNotActivated, PartnerTopicProvisioningState? provisioningState, PartnerTopicActivationState? activationState, string partnerTopicFriendlyDescription, string messageForActivation, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            PartnerRegistrationImmutableId = partnerRegistrationImmutableId;
            Source = source;
            EventTypeInfo = eventTypeInfo;
            ExpireOnIfNotActivated = expireOnIfNotActivated;
            ProvisioningState = provisioningState;
            ActivationState = activationState;
            PartnerTopicFriendlyDescription = partnerTopicFriendlyDescription;
            MessageForActivation = messageForActivation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PartnerTopicData"/> for deserialization. </summary>
        internal PartnerTopicData()
        {
        }

        /// <summary> Identity information for the Partner Topic resource. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The immutableId of the corresponding partner registration. </summary>
        [WirePath("properties.partnerRegistrationImmutableId")]
        public Guid? PartnerRegistrationImmutableId { get; set; }
        /// <summary> Source associated with this partner topic. This represents a unique partner resource. </summary>
        [WirePath("properties.source")]
        public string Source { get; set; }
        /// <summary> Event Type information from the corresponding event channel. </summary>
        [WirePath("properties.eventTypeInfo")]
        public PartnerTopicEventTypeInfo EventTypeInfo { get; set; }
        /// <summary>
        /// Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
        /// the partner topic and corresponding event channel are deleted.
        /// </summary>
        [WirePath("properties.expirationTimeIfNotActivatedUtc")]
        public DateTimeOffset? ExpireOnIfNotActivated { get; set; }
        /// <summary> Provisioning state of the partner topic. </summary>
        [WirePath("properties.provisioningState")]
        public PartnerTopicProvisioningState? ProvisioningState { get; }
        /// <summary> Activation state of the partner topic. </summary>
        [WirePath("properties.activationState")]
        public PartnerTopicActivationState? ActivationState { get; set; }
        /// <summary>
        /// Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
        /// This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
        /// </summary>
        [WirePath("properties.partnerTopicFriendlyDescription")]
        public string PartnerTopicFriendlyDescription { get; set; }
        /// <summary> Context or helpful message that can be used during the approval process by the subscriber. </summary>
        [WirePath("properties.messageForActivation")]
        public string MessageForActivation { get; set; }
    }
}
