// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventGrid.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventGrid
{
    /// <summary>
    /// A class representing the PartnerRegistration data model.
    /// Information about a partner registration.
    /// </summary>
    public partial class PartnerRegistrationData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerRegistrationData"/>. </summary>
        /// <param name="location"> The location. </param>
        public PartnerRegistrationData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="PartnerRegistrationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state of the partner registration. </param>
        /// <param name="partnerRegistrationImmutableId">
        /// The immutableId of the corresponding partner registration.
        /// Note: This property is marked for deprecation and is not supported in any future GA API version
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerRegistrationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, PartnerRegistrationProvisioningState? provisioningState, Guid? partnerRegistrationImmutableId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ProvisioningState = provisioningState;
            PartnerRegistrationImmutableId = partnerRegistrationImmutableId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PartnerRegistrationData"/> for deserialization. </summary>
        internal PartnerRegistrationData()
        {
        }

        /// <summary> Provisioning state of the partner registration. </summary>
        [WirePath("properties.provisioningState")]
        public PartnerRegistrationProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// The immutableId of the corresponding partner registration.
        /// Note: This property is marked for deprecation and is not supported in any future GA API version
        /// </summary>
        [WirePath("properties.partnerRegistrationImmutableId")]
        public Guid? PartnerRegistrationImmutableId { get; set; }
    }
}
