// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.EventGrid
{
    /// <summary>
    /// A class representing a collection of <see cref="PartnerNamespaceChannelResource"/> and their operations.
    /// Each <see cref="PartnerNamespaceChannelResource"/> in the collection will belong to the same instance of <see cref="PartnerNamespaceResource"/>.
    /// To get a <see cref="PartnerNamespaceChannelCollection"/> instance call the GetPartnerNamespaceChannels method from an instance of <see cref="PartnerNamespaceResource"/>.
    /// </summary>
    public partial class PartnerNamespaceChannelCollection : ArmCollection, IEnumerable<PartnerNamespaceChannelResource>, IAsyncEnumerable<PartnerNamespaceChannelResource>
    {
        private readonly ClientDiagnostics _partnerNamespaceChannelChannelsClientDiagnostics;
        private readonly ChannelsRestOperations _partnerNamespaceChannelChannelsRestClient;

        /// <summary> Initializes a new instance of the <see cref="PartnerNamespaceChannelCollection"/> class for mocking. </summary>
        protected PartnerNamespaceChannelCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="PartnerNamespaceChannelCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal PartnerNamespaceChannelCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _partnerNamespaceChannelChannelsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.EventGrid", PartnerNamespaceChannelResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(PartnerNamespaceChannelResource.ResourceType, out string partnerNamespaceChannelChannelsApiVersion);
            _partnerNamespaceChannelChannelsRestClient = new ChannelsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, partnerNamespaceChannelChannelsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PartnerNamespaceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PartnerNamespaceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Synchronously creates or updates a new channel with the specified parameters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="data"> Channel information. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<PartnerNamespaceChannelResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string channelName, PartnerNamespaceChannelData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _partnerNamespaceChannelChannelsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, data, cancellationToken).ConfigureAwait(false);
                var uri = _partnerNamespaceChannelChannelsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new EventGridArmOperation<PartnerNamespaceChannelResource>(Response.FromValue(new PartnerNamespaceChannelResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Synchronously creates or updates a new channel with the specified parameters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="data"> Channel information. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<PartnerNamespaceChannelResource> CreateOrUpdate(WaitUntil waitUntil, string channelName, PartnerNamespaceChannelData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _partnerNamespaceChannelChannelsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, data, cancellationToken);
                var uri = _partnerNamespaceChannelChannelsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new EventGridArmOperation<PartnerNamespaceChannelResource>(Response.FromValue(new PartnerNamespaceChannelResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get properties of a channel.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> is null. </exception>
        public virtual async Task<Response<PartnerNamespaceChannelResource>> GetAsync(string channelName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.Get");
            scope.Start();
            try
            {
                var response = await _partnerNamespaceChannelChannelsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new PartnerNamespaceChannelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get properties of a channel.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> is null. </exception>
        public virtual Response<PartnerNamespaceChannelResource> Get(string channelName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.Get");
            scope.Start();
            try
            {
                var response = _partnerNamespaceChannelChannelsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new PartnerNamespaceChannelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List all the channels in a partner namespace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_ListByPartnerNamespace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and with limited number of OData operations. These operations are: the 'contains' function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'. </param>
        /// <param name="top"> The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified, the default number of results to be returned is 20 items per page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="PartnerNamespaceChannelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<PartnerNamespaceChannelResource> GetAllAsync(string filter = null, int? top = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _partnerNamespaceChannelChannelsRestClient.CreateListByPartnerNamespaceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _partnerNamespaceChannelChannelsRestClient.CreateListByPartnerNamespaceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new PartnerNamespaceChannelResource(Client, PartnerNamespaceChannelData.DeserializePartnerNamespaceChannelData(e)), _partnerNamespaceChannelChannelsClientDiagnostics, Pipeline, "PartnerNamespaceChannelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List all the channels in a partner namespace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_ListByPartnerNamespace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and with limited number of OData operations. These operations are: the 'contains' function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'. </param>
        /// <param name="top"> The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified, the default number of results to be returned is 20 items per page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="PartnerNamespaceChannelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<PartnerNamespaceChannelResource> GetAll(string filter = null, int? top = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _partnerNamespaceChannelChannelsRestClient.CreateListByPartnerNamespaceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _partnerNamespaceChannelChannelsRestClient.CreateListByPartnerNamespaceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new PartnerNamespaceChannelResource(Client, PartnerNamespaceChannelData.DeserializePartnerNamespaceChannelData(e)), _partnerNamespaceChannelChannelsClientDiagnostics, Pipeline, "PartnerNamespaceChannelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string channelName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.Exists");
            scope.Start();
            try
            {
                var response = await _partnerNamespaceChannelChannelsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> is null. </exception>
        public virtual Response<bool> Exists(string channelName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.Exists");
            scope.Start();
            try
            {
                var response = _partnerNamespaceChannelChannelsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> is null. </exception>
        public virtual async Task<NullableResponse<PartnerNamespaceChannelResource>> GetIfExistsAsync(string channelName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _partnerNamespaceChannelChannelsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<PartnerNamespaceChannelResource>(response.GetRawResponse());
                return Response.FromValue(new PartnerNamespaceChannelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Channels_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceChannelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="channelName"> Name of the channel. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="channelName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="channelName"/> is null. </exception>
        public virtual NullableResponse<PartnerNamespaceChannelResource> GetIfExists(string channelName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(channelName, nameof(channelName));

            using var scope = _partnerNamespaceChannelChannelsClientDiagnostics.CreateScope("PartnerNamespaceChannelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _partnerNamespaceChannelChannelsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, channelName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<PartnerNamespaceChannelResource>(response.GetRawResponse());
                return Response.FromValue(new PartnerNamespaceChannelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<PartnerNamespaceChannelResource> IEnumerable<PartnerNamespaceChannelResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<PartnerNamespaceChannelResource> IAsyncEnumerable<PartnerNamespaceChannelResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
