// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventGrid.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventGrid
{
    /// <summary>
    /// A class representing the PartnerDestination data model.
    /// Event Grid Partner Destination.
    /// </summary>
    public partial class PartnerDestinationData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerDestinationData"/>. </summary>
        /// <param name="location"> The location. </param>
        public PartnerDestinationData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="PartnerDestinationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="partnerRegistrationImmutableId"> The immutable Id of the corresponding partner registration. </param>
        /// <param name="endpointServiceContext"> Endpoint context associated with this partner destination. </param>
        /// <param name="expirationTimeIfNotActivatedUtc">
        /// Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
        /// the partner destination and corresponding channel are deleted.
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the partner destination. </param>
        /// <param name="activationState"> Activation state of the partner destination. </param>
        /// <param name="endpointBaseUri"> Endpoint Base URL of the partner destination. </param>
        /// <param name="messageForActivation"> Context or helpful message that can be used during the approval process. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerDestinationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, Guid? partnerRegistrationImmutableId, string endpointServiceContext, DateTimeOffset? expirationTimeIfNotActivatedUtc, PartnerDestinationProvisioningState? provisioningState, PartnerDestinationActivationState? activationState, Uri endpointBaseUri, string messageForActivation, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            PartnerRegistrationImmutableId = partnerRegistrationImmutableId;
            EndpointServiceContext = endpointServiceContext;
            ExpirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc;
            ProvisioningState = provisioningState;
            ActivationState = activationState;
            EndpointBaseUri = endpointBaseUri;
            MessageForActivation = messageForActivation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PartnerDestinationData"/> for deserialization. </summary>
        internal PartnerDestinationData()
        {
        }

        /// <summary> The immutable Id of the corresponding partner registration. </summary>
        [WirePath("properties.partnerRegistrationImmutableId")]
        public Guid? PartnerRegistrationImmutableId { get; set; }
        /// <summary> Endpoint context associated with this partner destination. </summary>
        [WirePath("properties.endpointServiceContext")]
        public string EndpointServiceContext { get; set; }
        /// <summary>
        /// Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
        /// the partner destination and corresponding channel are deleted.
        /// </summary>
        [WirePath("properties.expirationTimeIfNotActivatedUtc")]
        public DateTimeOffset? ExpirationTimeIfNotActivatedUtc { get; set; }
        /// <summary> Provisioning state of the partner destination. </summary>
        [WirePath("properties.provisioningState")]
        public PartnerDestinationProvisioningState? ProvisioningState { get; }
        /// <summary> Activation state of the partner destination. </summary>
        [WirePath("properties.activationState")]
        public PartnerDestinationActivationState? ActivationState { get; set; }
        /// <summary> Endpoint Base URL of the partner destination. </summary>
        [WirePath("properties.endpointBaseUrl")]
        public Uri EndpointBaseUri { get; set; }
        /// <summary> Context or helpful message that can be used during the approval process. </summary>
        [WirePath("properties.messageForActivation")]
        public string MessageForActivation { get; set; }
    }
}
