// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Information about the WebHook of the partner destination. </summary>
    public partial class WebhookPartnerDestinationInfo : PartnerDestinationInfo
    {
        /// <summary> Initializes a new instance of <see cref="WebhookPartnerDestinationInfo"/>. </summary>
        public WebhookPartnerDestinationInfo()
        {
            EndpointType = PartnerEndpointType.WebHook;
        }

        /// <summary> Initializes a new instance of <see cref="WebhookPartnerDestinationInfo"/>. </summary>
        /// <param name="azureSubscriptionId">
        /// Azure subscription ID of the subscriber. The partner destination associated with the channel will be
        /// created under this Azure subscription.
        /// </param>
        /// <param name="resourceGroupName">
        /// Azure Resource Group of the subscriber. The partner destination associated with the channel will be
        /// created under this resource group.
        /// </param>
        /// <param name="name"> Name of the partner destination associated with the channel. </param>
        /// <param name="endpointType"> Type of the endpoint for the partner destination. </param>
        /// <param name="endpointServiceContext"> Additional context of the partner destination endpoint. </param>
        /// <param name="resourceMoveChangeHistory"> Change history of the resource move. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="endpointUri"> The URL that represents the endpoint of the partner destination. </param>
        /// <param name="endpointBaseUri"> The base URL that represents the endpoint of the partner destination. </param>
        /// <param name="clientAuthentication">
        /// Partner client authentication
        /// Please note <see cref="PartnerClientAuthentication"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureADPartnerClientAuthentication"/>.
        /// </param>
        internal WebhookPartnerDestinationInfo(string azureSubscriptionId, string resourceGroupName, string name, PartnerEndpointType endpointType, string endpointServiceContext, IList<ResourceMoveChangeHistory> resourceMoveChangeHistory, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri endpointUri, Uri endpointBaseUri, PartnerClientAuthentication clientAuthentication) : base(azureSubscriptionId, resourceGroupName, name, endpointType, endpointServiceContext, resourceMoveChangeHistory, serializedAdditionalRawData)
        {
            EndpointUri = endpointUri;
            EndpointBaseUri = endpointBaseUri;
            ClientAuthentication = clientAuthentication;
            EndpointType = endpointType;
        }

        /// <summary> The URL that represents the endpoint of the partner destination. </summary>
        [WirePath("properties.endpointUrl")]
        public Uri EndpointUri { get; set; }
        /// <summary> The base URL that represents the endpoint of the partner destination. </summary>
        [WirePath("properties.endpointBaseUrl")]
        public Uri EndpointBaseUri { get; set; }
        /// <summary>
        /// Partner client authentication
        /// Please note <see cref="PartnerClientAuthentication"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureADPartnerClientAuthentication"/>.
        /// </summary>
        [WirePath("properties.clientAuthentication")]
        public PartnerClientAuthentication ClientAuthentication { get; set; }
    }
}
