// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the verified partner. </summary>
    public readonly partial struct VerifiedPartnerProvisioningState : IEquatable<VerifiedPartnerProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VerifiedPartnerProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VerifiedPartnerProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static VerifiedPartnerProvisioningState Creating { get; } = new VerifiedPartnerProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static VerifiedPartnerProvisioningState Updating { get; } = new VerifiedPartnerProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static VerifiedPartnerProvisioningState Deleting { get; } = new VerifiedPartnerProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static VerifiedPartnerProvisioningState Succeeded { get; } = new VerifiedPartnerProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static VerifiedPartnerProvisioningState Canceled { get; } = new VerifiedPartnerProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static VerifiedPartnerProvisioningState Failed { get; } = new VerifiedPartnerProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="VerifiedPartnerProvisioningState"/> values are the same. </summary>
        public static bool operator ==(VerifiedPartnerProvisioningState left, VerifiedPartnerProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VerifiedPartnerProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(VerifiedPartnerProvisioningState left, VerifiedPartnerProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VerifiedPartnerProvisioningState"/>. </summary>
        public static implicit operator VerifiedPartnerProvisioningState(string value) => new VerifiedPartnerProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VerifiedPartnerProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VerifiedPartnerProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
