// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Unknown version of PartnerDestinationInfo. </summary>
    internal partial class UnknownPartnerDestinationInfo : PartnerDestinationInfo
    {
        /// <summary> Initializes a new instance of <see cref="UnknownPartnerDestinationInfo"/>. </summary>
        /// <param name="azureSubscriptionId">
        /// Azure subscription ID of the subscriber. The partner destination associated with the channel will be
        /// created under this Azure subscription.
        /// </param>
        /// <param name="resourceGroupName">
        /// Azure Resource Group of the subscriber. The partner destination associated with the channel will be
        /// created under this resource group.
        /// </param>
        /// <param name="name"> Name of the partner destination associated with the channel. </param>
        /// <param name="endpointType"> Type of the endpoint for the partner destination. </param>
        /// <param name="endpointServiceContext"> Additional context of the partner destination endpoint. </param>
        /// <param name="resourceMoveChangeHistory"> Change history of the resource move. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownPartnerDestinationInfo(string azureSubscriptionId, string resourceGroupName, string name, PartnerEndpointType endpointType, string endpointServiceContext, IList<ResourceMoveChangeHistory> resourceMoveChangeHistory, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(azureSubscriptionId, resourceGroupName, name, endpointType, endpointServiceContext, resourceMoveChangeHistory, serializedAdditionalRawData)
        {
            EndpointType = endpointType;
        }

        /// <summary> Initializes a new instance of <see cref="UnknownPartnerDestinationInfo"/> for deserialization. </summary>
        internal UnknownPartnerDestinationInfo()
        {
        }
    }
}
