// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled. </summary>
    public readonly partial struct TopicSpacesConfigurationState : IEquatable<TopicSpacesConfigurationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TopicSpacesConfigurationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TopicSpacesConfigurationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static TopicSpacesConfigurationState Disabled { get; } = new TopicSpacesConfigurationState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static TopicSpacesConfigurationState Enabled { get; } = new TopicSpacesConfigurationState(EnabledValue);
        /// <summary> Determines if two <see cref="TopicSpacesConfigurationState"/> values are the same. </summary>
        public static bool operator ==(TopicSpacesConfigurationState left, TopicSpacesConfigurationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TopicSpacesConfigurationState"/> values are not the same. </summary>
        public static bool operator !=(TopicSpacesConfigurationState left, TopicSpacesConfigurationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TopicSpacesConfigurationState"/>. </summary>
        public static implicit operator TopicSpacesConfigurationState(string value) => new TopicSpacesConfigurationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TopicSpacesConfigurationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TopicSpacesConfigurationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
