// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Properties of the Topic Spaces Configuration. </summary>
    public partial class TopicSpacesConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TopicSpacesConfiguration"/>. </summary>
        public TopicSpacesConfiguration()
        {
            CustomDomains = new ChangeTrackingList<CustomDomainConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="TopicSpacesConfiguration"/>. </summary>
        /// <param name="state"> Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled. </param>
        /// <param name="routeTopicResourceId">
        /// Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
        /// This property should be in the following format '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
        /// This topic should reside in the same region where namespace is located.
        /// </param>
        /// <param name="hostname"> The endpoint for the topic spaces configuration. This is a read-only property. </param>
        /// <param name="routingEnrichments"> Routing enrichments for topic spaces configuration. </param>
        /// <param name="clientAuthentication"> Client authentication settings for topic spaces configuration. </param>
        /// <param name="maximumSessionExpiryInHours">
        /// The maximum session expiry in hours. The property default value is 1 hour.
        /// Min allowed value is 1 hour and max allowed value is 8 hours.
        /// </param>
        /// <param name="maximumClientSessionsPerAuthenticationName">
        /// The maximum number of sessions per authentication name. The property default value is 1.
        /// Min allowed value is 1 and max allowed value is 100.
        /// </param>
        /// <param name="routingIdentityInfo"> Routing identity info for topic spaces configuration. </param>
        /// <param name="customDomains"> List of custom domain configurations for the namespace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TopicSpacesConfiguration(TopicSpacesConfigurationState? state, string routeTopicResourceId, string hostname, RoutingEnrichments routingEnrichments, ClientAuthenticationSettings clientAuthentication, int? maximumSessionExpiryInHours, int? maximumClientSessionsPerAuthenticationName, RoutingIdentityInfo routingIdentityInfo, IList<CustomDomainConfiguration> customDomains, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            RouteTopicResourceId = routeTopicResourceId;
            Hostname = hostname;
            RoutingEnrichments = routingEnrichments;
            ClientAuthentication = clientAuthentication;
            MaximumSessionExpiryInHours = maximumSessionExpiryInHours;
            MaximumClientSessionsPerAuthenticationName = maximumClientSessionsPerAuthenticationName;
            RoutingIdentityInfo = routingIdentityInfo;
            CustomDomains = customDomains;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled. </summary>
        [WirePath("state")]
        public TopicSpacesConfigurationState? State { get; set; }
        /// <summary>
        /// Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
        /// This property should be in the following format '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
        /// This topic should reside in the same region where namespace is located.
        /// </summary>
        [WirePath("routeTopicResourceId")]
        public string RouteTopicResourceId { get; set; }
        /// <summary> The endpoint for the topic spaces configuration. This is a read-only property. </summary>
        [WirePath("hostname")]
        public string Hostname { get; }
        /// <summary> Routing enrichments for topic spaces configuration. </summary>
        [WirePath("routingEnrichments")]
        public RoutingEnrichments RoutingEnrichments { get; set; }
        /// <summary> Client authentication settings for topic spaces configuration. </summary>
        [WirePath("clientAuthentication")]
        public ClientAuthenticationSettings ClientAuthentication { get; set; }
        /// <summary>
        /// The maximum session expiry in hours. The property default value is 1 hour.
        /// Min allowed value is 1 hour and max allowed value is 8 hours.
        /// </summary>
        [WirePath("maximumSessionExpiryInHours")]
        public int? MaximumSessionExpiryInHours { get; set; }
        /// <summary>
        /// The maximum number of sessions per authentication name. The property default value is 1.
        /// Min allowed value is 1 and max allowed value is 100.
        /// </summary>
        [WirePath("maximumClientSessionsPerAuthenticationName")]
        public int? MaximumClientSessionsPerAuthenticationName { get; set; }
        /// <summary> Routing identity info for topic spaces configuration. </summary>
        [WirePath("routingIdentityInfo")]
        public RoutingIdentityInfo RoutingIdentityInfo { get; set; }
        /// <summary> List of custom domain configurations for the namespace. </summary>
        [WirePath("customDomains")]
        public IList<CustomDomainConfiguration> CustomDomains { get; }
    }
}
