// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    public partial class TopicSpacesConfiguration : IUtf8JsonSerializable, IJsonModel<TopicSpacesConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<TopicSpacesConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<TopicSpacesConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopicSpacesConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TopicSpacesConfiguration)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(RouteTopicResourceId))
            {
                writer.WritePropertyName("routeTopicResourceId"u8);
                writer.WriteStringValue(RouteTopicResourceId);
            }
            if (options.Format != "W" && Optional.IsDefined(Hostname))
            {
                writer.WritePropertyName("hostname"u8);
                writer.WriteStringValue(Hostname);
            }
            if (Optional.IsDefined(RoutingEnrichments))
            {
                writer.WritePropertyName("routingEnrichments"u8);
                writer.WriteObjectValue(RoutingEnrichments, options);
            }
            if (Optional.IsDefined(ClientAuthentication))
            {
                writer.WritePropertyName("clientAuthentication"u8);
                writer.WriteObjectValue(ClientAuthentication, options);
            }
            if (Optional.IsDefined(MaximumSessionExpiryInHours))
            {
                writer.WritePropertyName("maximumSessionExpiryInHours"u8);
                writer.WriteNumberValue(MaximumSessionExpiryInHours.Value);
            }
            if (Optional.IsDefined(MaximumClientSessionsPerAuthenticationName))
            {
                writer.WritePropertyName("maximumClientSessionsPerAuthenticationName"u8);
                writer.WriteNumberValue(MaximumClientSessionsPerAuthenticationName.Value);
            }
            if (Optional.IsDefined(RoutingIdentityInfo))
            {
                writer.WritePropertyName("routingIdentityInfo"u8);
                writer.WriteObjectValue(RoutingIdentityInfo, options);
            }
            if (Optional.IsCollectionDefined(CustomDomains))
            {
                writer.WritePropertyName("customDomains"u8);
                writer.WriteStartArray();
                foreach (var item in CustomDomains)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        TopicSpacesConfiguration IJsonModel<TopicSpacesConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopicSpacesConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TopicSpacesConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeTopicSpacesConfiguration(document.RootElement, options);
        }

        internal static TopicSpacesConfiguration DeserializeTopicSpacesConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TopicSpacesConfigurationState? state = default;
            string routeTopicResourceId = default;
            string hostname = default;
            RoutingEnrichments routingEnrichments = default;
            ClientAuthenticationSettings clientAuthentication = default;
            int? maximumSessionExpiryInHours = default;
            int? maximumClientSessionsPerAuthenticationName = default;
            RoutingIdentityInfo routingIdentityInfo = default;
            IList<CustomDomainConfiguration> customDomains = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new TopicSpacesConfigurationState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("routeTopicResourceId"u8))
                {
                    routeTopicResourceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hostname"u8))
                {
                    hostname = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("routingEnrichments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    routingEnrichments = RoutingEnrichments.DeserializeRoutingEnrichments(property.Value, options);
                    continue;
                }
                if (property.NameEquals("clientAuthentication"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clientAuthentication = ClientAuthenticationSettings.DeserializeClientAuthenticationSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("maximumSessionExpiryInHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximumSessionExpiryInHours = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maximumClientSessionsPerAuthenticationName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximumClientSessionsPerAuthenticationName = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("routingIdentityInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    routingIdentityInfo = RoutingIdentityInfo.DeserializeRoutingIdentityInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("customDomains"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CustomDomainConfiguration> array = new List<CustomDomainConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CustomDomainConfiguration.DeserializeCustomDomainConfiguration(item, options));
                    }
                    customDomains = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new TopicSpacesConfiguration(
                state,
                routeTopicResourceId,
                hostname,
                routingEnrichments,
                clientAuthentication,
                maximumSessionExpiryInHours,
                maximumClientSessionsPerAuthenticationName,
                routingIdentityInfo,
                customDomains ?? new ChangeTrackingList<CustomDomainConfiguration>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("  state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RouteTopicResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  routeTopicResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RouteTopicResourceId))
                {
                    builder.Append("  routeTopicResourceId: ");
                    if (RouteTopicResourceId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RouteTopicResourceId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RouteTopicResourceId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Hostname), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hostname: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Hostname))
                {
                    builder.Append("  hostname: ");
                    if (Hostname.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Hostname}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Hostname}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RoutingEnrichments), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  routingEnrichments: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RoutingEnrichments))
                {
                    builder.Append("  routingEnrichments: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RoutingEnrichments, options, 2, false, "  routingEnrichments: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClientAuthentication), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clientAuthentication: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClientAuthentication))
                {
                    builder.Append("  clientAuthentication: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ClientAuthentication, options, 2, false, "  clientAuthentication: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaximumSessionExpiryInHours), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maximumSessionExpiryInHours: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaximumSessionExpiryInHours))
                {
                    builder.Append("  maximumSessionExpiryInHours: ");
                    builder.AppendLine($"{MaximumSessionExpiryInHours.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaximumClientSessionsPerAuthenticationName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maximumClientSessionsPerAuthenticationName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaximumClientSessionsPerAuthenticationName))
                {
                    builder.Append("  maximumClientSessionsPerAuthenticationName: ");
                    builder.AppendLine($"{MaximumClientSessionsPerAuthenticationName.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RoutingIdentityInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  routingIdentityInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RoutingIdentityInfo))
                {
                    builder.Append("  routingIdentityInfo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RoutingIdentityInfo, options, 2, false, "  routingIdentityInfo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomDomains), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customDomains: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CustomDomains))
                {
                    if (CustomDomains.Any())
                    {
                        builder.Append("  customDomains: ");
                        builder.AppendLine("[");
                        foreach (var item in CustomDomains)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  customDomains: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<TopicSpacesConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopicSpacesConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(TopicSpacesConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        TopicSpacesConfiguration IPersistableModel<TopicSpacesConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopicSpacesConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeTopicSpacesConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(TopicSpacesConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<TopicSpacesConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
