// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Information about the storage blob based dead letter destination. </summary>
    public partial class StorageBlobDeadLetterDestination : DeadLetterDestination
    {
        /// <summary> Initializes a new instance of <see cref="StorageBlobDeadLetterDestination"/>. </summary>
        public StorageBlobDeadLetterDestination()
        {
            EndpointType = DeadLetterEndPointType.StorageBlob;
        }

        /// <summary> Initializes a new instance of <see cref="StorageBlobDeadLetterDestination"/>. </summary>
        /// <param name="endpointType"> Type of the endpoint for the dead letter destination. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="resourceId"> The Azure Resource ID of the storage account that is the destination of the deadletter events. </param>
        /// <param name="blobContainerName"> The name of the Storage blob container that is the destination of the deadletter events. </param>
        internal StorageBlobDeadLetterDestination(DeadLetterEndPointType endpointType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier resourceId, string blobContainerName) : base(endpointType, serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            BlobContainerName = blobContainerName;
            EndpointType = endpointType;
        }

        /// <summary> The Azure Resource ID of the storage account that is the destination of the deadletter events. </summary>
        [WirePath("properties.resourceId")]
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> The name of the Storage blob container that is the destination of the deadletter events. </summary>
        [WirePath("properties.blobContainerName")]
        public string BlobContainerName { get; set; }
    }
}
