// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The StaticStringRoutingEnrichment. </summary>
    public partial class StaticStringRoutingEnrichment : StaticRoutingEnrichment
    {
        /// <summary> Initializes a new instance of <see cref="StaticStringRoutingEnrichment"/>. </summary>
        public StaticStringRoutingEnrichment()
        {
            ValueType = StaticRoutingEnrichmentType.String;
        }

        /// <summary> Initializes a new instance of <see cref="StaticStringRoutingEnrichment"/>. </summary>
        /// <param name="key"> Static routing enrichment key. </param>
        /// <param name="valueType"> Static routing enrichment value type. For e.g. this property value can be 'String'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> String type routing enrichment value. </param>
        internal StaticStringRoutingEnrichment(string key, StaticRoutingEnrichmentType valueType, IDictionary<string, BinaryData> serializedAdditionalRawData, string value) : base(key, valueType, serializedAdditionalRawData)
        {
            Value = value;
            ValueType = valueType;
        }

        /// <summary> String type routing enrichment value. </summary>
        [WirePath("value")]
        public string Value { get; set; }
    }
}
