// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary>
    /// Static routing enrichment details.
    /// Please note <see cref="StaticRoutingEnrichment"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="StaticStringRoutingEnrichment"/>.
    /// </summary>
    public abstract partial class StaticRoutingEnrichment
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StaticRoutingEnrichment"/>. </summary>
        protected StaticRoutingEnrichment()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StaticRoutingEnrichment"/>. </summary>
        /// <param name="key"> Static routing enrichment key. </param>
        /// <param name="valueType"> Static routing enrichment value type. For e.g. this property value can be 'String'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StaticRoutingEnrichment(string key, StaticRoutingEnrichmentType valueType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Key = key;
            ValueType = valueType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Static routing enrichment key. </summary>
        [WirePath("key")]
        public string Key { get; set; }
        /// <summary> Static routing enrichment value type. For e.g. this property value can be 'String'. </summary>
        internal StaticRoutingEnrichmentType ValueType { get; set; }
    }
}
