// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Static delivery attribute mapping details. </summary>
    public partial class StaticDeliveryAttributeMapping : DeliveryAttributeMapping
    {
        /// <summary> Initializes a new instance of <see cref="StaticDeliveryAttributeMapping"/>. </summary>
        public StaticDeliveryAttributeMapping()
        {
            MappingType = DeliveryAttributeMappingType.Static;
        }

        /// <summary> Initializes a new instance of <see cref="StaticDeliveryAttributeMapping"/>. </summary>
        /// <param name="name"> Name of the delivery attribute or header. </param>
        /// <param name="mappingType"> Type of the delivery attribute or header name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> Value of the delivery attribute. </param>
        /// <param name="isSecret"> Boolean flag to tell if the attribute contains sensitive information . </param>
        internal StaticDeliveryAttributeMapping(string name, DeliveryAttributeMappingType mappingType, IDictionary<string, BinaryData> serializedAdditionalRawData, string value, bool? isSecret) : base(name, mappingType, serializedAdditionalRawData)
        {
            Value = value;
            IsSecret = isSecret;
            MappingType = mappingType;
        }

        /// <summary> Value of the delivery attribute. </summary>
        [WirePath("properties.value")]
        public string Value { get; set; }
        /// <summary> Boolean flag to tell if the attribute contains sensitive information . </summary>
        [WirePath("properties.isSecret")]
        public bool? IsSecret { get; set; }
    }
}
