// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Routing identity type for topic spaces configuration. </summary>
    public readonly partial struct RoutingIdentityType : IEquatable<RoutingIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoutingIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoutingIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SystemAssignedValue = "SystemAssigned";
        private const string UserAssignedValue = "UserAssigned";

        /// <summary> None. </summary>
        public static RoutingIdentityType None { get; } = new RoutingIdentityType(NoneValue);
        /// <summary> SystemAssigned. </summary>
        public static RoutingIdentityType SystemAssigned { get; } = new RoutingIdentityType(SystemAssignedValue);
        /// <summary> UserAssigned. </summary>
        public static RoutingIdentityType UserAssigned { get; } = new RoutingIdentityType(UserAssignedValue);
        /// <summary> Determines if two <see cref="RoutingIdentityType"/> values are the same. </summary>
        public static bool operator ==(RoutingIdentityType left, RoutingIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoutingIdentityType"/> values are not the same. </summary>
        public static bool operator !=(RoutingIdentityType left, RoutingIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoutingIdentityType"/>. </summary>
        public static implicit operator RoutingIdentityType(string value) => new RoutingIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoutingIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoutingIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
