// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    public partial class RoutingEnrichments : IUtf8JsonSerializable, IJsonModel<RoutingEnrichments>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RoutingEnrichments>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RoutingEnrichments>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoutingEnrichments>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RoutingEnrichments)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Static))
            {
                writer.WritePropertyName("static"u8);
                writer.WriteStartArray();
                foreach (var item in Static)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Dynamic))
            {
                writer.WritePropertyName("dynamic"u8);
                writer.WriteStartArray();
                foreach (var item in Dynamic)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RoutingEnrichments IJsonModel<RoutingEnrichments>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoutingEnrichments>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RoutingEnrichments)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRoutingEnrichments(document.RootElement, options);
        }

        internal static RoutingEnrichments DeserializeRoutingEnrichments(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<StaticRoutingEnrichment> @static = default;
            IList<DynamicRoutingEnrichment> @dynamic = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("static"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<StaticRoutingEnrichment> array = new List<StaticRoutingEnrichment>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(StaticRoutingEnrichment.DeserializeStaticRoutingEnrichment(item, options));
                    }
                    @static = array;
                    continue;
                }
                if (property.NameEquals("dynamic"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DynamicRoutingEnrichment> array = new List<DynamicRoutingEnrichment>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DynamicRoutingEnrichment.DeserializeDynamicRoutingEnrichment(item, options));
                    }
                    @dynamic = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RoutingEnrichments(@static ?? new ChangeTrackingList<StaticRoutingEnrichment>(), @dynamic ?? new ChangeTrackingList<DynamicRoutingEnrichment>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Static), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  static: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Static))
                {
                    if (Static.Any())
                    {
                        builder.Append("  static: ");
                        builder.AppendLine("[");
                        foreach (var item in Static)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  static: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Dynamic), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dynamic: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Dynamic))
                {
                    if (Dynamic.Any())
                    {
                        builder.Append("  dynamic: ");
                        builder.AppendLine("[");
                        foreach (var item in Dynamic)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  dynamic: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RoutingEnrichments>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoutingEnrichments>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RoutingEnrichments)} does not support writing '{options.Format}' format.");
            }
        }

        RoutingEnrichments IPersistableModel<RoutingEnrichments>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoutingEnrichments>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRoutingEnrichments(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RoutingEnrichments)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RoutingEnrichments>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
