// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The change history of the resource move. </summary>
    public partial class ResourceMoveChangeHistory
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceMoveChangeHistory"/>. </summary>
        public ResourceMoveChangeHistory()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceMoveChangeHistory"/>. </summary>
        /// <param name="azureSubscriptionId"> Azure subscription ID of the resource. </param>
        /// <param name="resourceGroupName"> Azure Resource Group of the resource. </param>
        /// <param name="changedTimeUtc"> UTC timestamp of when the resource was changed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceMoveChangeHistory(string azureSubscriptionId, string resourceGroupName, DateTimeOffset? changedTimeUtc, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureSubscriptionId = azureSubscriptionId;
            ResourceGroupName = resourceGroupName;
            ChangedTimeUtc = changedTimeUtc;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Azure subscription ID of the resource. </summary>
        [WirePath("azureSubscriptionId")]
        public string AzureSubscriptionId { get; set; }
        /// <summary> Azure Resource Group of the resource. </summary>
        [WirePath("resourceGroupName")]
        public string ResourceGroupName { get; set; }
        /// <summary> UTC timestamp of when the resource was changed. </summary>
        [WirePath("changedTimeUtc")]
        public DateTimeOffset? ChangedTimeUtc { get; set; }
    }
}
