// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Kind of the resource. </summary>
    public readonly partial struct ResourceKind : IEquatable<ResourceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "Azure";
        private const string AzureArcValue = "AzureArc";

        /// <summary> Azure. </summary>
        public static ResourceKind Azure { get; } = new ResourceKind(AzureValue);
        /// <summary> AzureArc. </summary>
        public static ResourceKind AzureArc { get; } = new ResourceKind(AzureArcValue);
        /// <summary> Determines if two <see cref="ResourceKind"/> values are the same. </summary>
        public static bool operator ==(ResourceKind left, ResourceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceKind"/> values are not the same. </summary>
        public static bool operator !=(ResourceKind left, ResourceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceKind"/>. </summary>
        public static implicit operator ResourceKind(string value) => new ResourceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
