// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Publisher type of the namespace topic. </summary>
    public readonly partial struct PublisherType : IEquatable<PublisherType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PublisherType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PublisherType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomValue = "Custom";

        /// <summary> Custom. </summary>
        public static PublisherType Custom { get; } = new PublisherType(CustomValue);
        /// <summary> Determines if two <see cref="PublisherType"/> values are the same. </summary>
        public static bool operator ==(PublisherType left, PublisherType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PublisherType"/> values are not the same. </summary>
        public static bool operator !=(PublisherType left, PublisherType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PublisherType"/>. </summary>
        public static implicit operator PublisherType(string value) => new PublisherType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PublisherType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PublisherType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
