// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The allowed permission. </summary>
    public readonly partial struct PermissionType : IEquatable<PermissionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PermissionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PermissionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PublisherValue = "Publisher";
        private const string SubscriberValue = "Subscriber";

        /// <summary> Publisher. </summary>
        public static PermissionType Publisher { get; } = new PermissionType(PublisherValue);
        /// <summary> Subscriber. </summary>
        public static PermissionType Subscriber { get; } = new PermissionType(SubscriberValue);
        /// <summary> Determines if two <see cref="PermissionType"/> values are the same. </summary>
        public static bool operator ==(PermissionType left, PermissionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PermissionType"/> values are not the same. </summary>
        public static bool operator !=(PermissionType left, PermissionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PermissionType"/>. </summary>
        public static implicit operator PermissionType(string value) => new PermissionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PermissionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PermissionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
