// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary>
    /// This determines if events published to this partner namespace should use the source attribute in the event payload
    /// or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
    /// </summary>
    public readonly partial struct PartnerTopicRoutingMode : IEquatable<PartnerTopicRoutingMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerTopicRoutingMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerTopicRoutingMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SourceEventAttributeValue = "SourceEventAttribute";
        private const string ChannelNameHeaderValue = "ChannelNameHeader";

        /// <summary> SourceEventAttribute. </summary>
        public static PartnerTopicRoutingMode SourceEventAttribute { get; } = new PartnerTopicRoutingMode(SourceEventAttributeValue);
        /// <summary> ChannelNameHeader. </summary>
        public static PartnerTopicRoutingMode ChannelNameHeader { get; } = new PartnerTopicRoutingMode(ChannelNameHeaderValue);
        /// <summary> Determines if two <see cref="PartnerTopicRoutingMode"/> values are the same. </summary>
        public static bool operator ==(PartnerTopicRoutingMode left, PartnerTopicRoutingMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerTopicRoutingMode"/> values are not the same. </summary>
        public static bool operator !=(PartnerTopicRoutingMode left, PartnerTopicRoutingMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerTopicRoutingMode"/>. </summary>
        public static implicit operator PartnerTopicRoutingMode(string value) => new PartnerTopicRoutingMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerTopicRoutingMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerTopicRoutingMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
