// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the partner topic. </summary>
    public readonly partial struct PartnerTopicProvisioningState : IEquatable<PartnerTopicProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerTopicProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerTopicProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string IdleDueToMirroredChannelResourceDeletionValue = "IdleDueToMirroredChannelResourceDeletion";

        /// <summary> Creating. </summary>
        public static PartnerTopicProvisioningState Creating { get; } = new PartnerTopicProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static PartnerTopicProvisioningState Updating { get; } = new PartnerTopicProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static PartnerTopicProvisioningState Deleting { get; } = new PartnerTopicProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static PartnerTopicProvisioningState Succeeded { get; } = new PartnerTopicProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static PartnerTopicProvisioningState Canceled { get; } = new PartnerTopicProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static PartnerTopicProvisioningState Failed { get; } = new PartnerTopicProvisioningState(FailedValue);
        /// <summary> IdleDueToMirroredChannelResourceDeletion. </summary>
        public static PartnerTopicProvisioningState IdleDueToMirroredChannelResourceDeletion { get; } = new PartnerTopicProvisioningState(IdleDueToMirroredChannelResourceDeletionValue);
        /// <summary> Determines if two <see cref="PartnerTopicProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PartnerTopicProvisioningState left, PartnerTopicProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerTopicProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PartnerTopicProvisioningState left, PartnerTopicProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerTopicProvisioningState"/>. </summary>
        public static implicit operator PartnerTopicProvisioningState(string value) => new PartnerTopicProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerTopicProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerTopicProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
