// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Properties of the corresponding partner topic of a Channel. </summary>
    public partial class PartnerTopicInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerTopicInfo"/>. </summary>
        public PartnerTopicInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PartnerTopicInfo"/>. </summary>
        /// <param name="azureSubscriptionId">
        /// Azure subscription ID of the subscriber. The partner topic associated with the channel will be
        /// created under this Azure subscription.
        /// </param>
        /// <param name="resourceGroupName">
        /// Azure Resource Group of the subscriber. The partner topic associated with the channel will be
        /// created under this resource group.
        /// </param>
        /// <param name="name"> Name of the partner topic associated with the channel. </param>
        /// <param name="eventTypeInfo">
        /// Event Type Information for the partner topic. This information is provided by the publisher and can be used by the
        /// subscriber to view different types of events that are published.
        /// </param>
        /// <param name="source">
        /// The source information is provided by the publisher to determine the scope or context from which the events
        /// are originating. This information can be used by the subscriber during the approval process of the
        /// created partner topic.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerTopicInfo(Guid? azureSubscriptionId, string resourceGroupName, string name, PartnerTopicEventTypeInfo eventTypeInfo, string source, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureSubscriptionId = azureSubscriptionId;
            ResourceGroupName = resourceGroupName;
            Name = name;
            EventTypeInfo = eventTypeInfo;
            Source = source;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Azure subscription ID of the subscriber. The partner topic associated with the channel will be
        /// created under this Azure subscription.
        /// </summary>
        [WirePath("azureSubscriptionId")]
        public Guid? AzureSubscriptionId { get; set; }
        /// <summary>
        /// Azure Resource Group of the subscriber. The partner topic associated with the channel will be
        /// created under this resource group.
        /// </summary>
        [WirePath("resourceGroupName")]
        public string ResourceGroupName { get; set; }
        /// <summary> Name of the partner topic associated with the channel. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary>
        /// Event Type Information for the partner topic. This information is provided by the publisher and can be used by the
        /// subscriber to view different types of events that are published.
        /// </summary>
        [WirePath("eventTypeInfo")]
        public PartnerTopicEventTypeInfo EventTypeInfo { get; set; }
        /// <summary>
        /// The source information is provided by the publisher to determine the scope or context from which the events
        /// are originating. This information can be used by the subscriber during the approval process of the
        /// created partner topic.
        /// </summary>
        [WirePath("source")]
        public string Source { get; set; }
    }
}
