// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The event type information for Channels. </summary>
    public partial class PartnerTopicEventTypeInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerTopicEventTypeInfo"/>. </summary>
        public PartnerTopicEventTypeInfo()
        {
            InlineEventTypes = new ChangeTrackingDictionary<string, InlineEventProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="PartnerTopicEventTypeInfo"/>. </summary>
        /// <param name="kind"> The kind of event type used. </param>
        /// <param name="inlineEventTypes">
        /// A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
        /// An example of a valid inline event name is "Contoso.OrderCreated".
        /// The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerTopicEventTypeInfo(EventDefinitionKind? kind, IDictionary<string, InlineEventProperties> inlineEventTypes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            InlineEventTypes = inlineEventTypes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The kind of event type used. </summary>
        [WirePath("kind")]
        public EventDefinitionKind? Kind { get; set; }
        /// <summary>
        /// A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
        /// An example of a valid inline event name is "Contoso.OrderCreated".
        /// The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
        /// </summary>
        [WirePath("inlineEventTypes")]
        public IDictionary<string, InlineEventProperties> InlineEventTypes { get; }
    }
}
