// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Activation state of the partner topic. </summary>
    public readonly partial struct PartnerTopicActivationState : IEquatable<PartnerTopicActivationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerTopicActivationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerTopicActivationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NeverActivatedValue = "NeverActivated";
        private const string ActivatedValue = "Activated";
        private const string DeactivatedValue = "Deactivated";

        /// <summary> NeverActivated. </summary>
        public static PartnerTopicActivationState NeverActivated { get; } = new PartnerTopicActivationState(NeverActivatedValue);
        /// <summary> Activated. </summary>
        public static PartnerTopicActivationState Activated { get; } = new PartnerTopicActivationState(ActivatedValue);
        /// <summary> Deactivated. </summary>
        public static PartnerTopicActivationState Deactivated { get; } = new PartnerTopicActivationState(DeactivatedValue);
        /// <summary> Determines if two <see cref="PartnerTopicActivationState"/> values are the same. </summary>
        public static bool operator ==(PartnerTopicActivationState left, PartnerTopicActivationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerTopicActivationState"/> values are not the same. </summary>
        public static bool operator !=(PartnerTopicActivationState left, PartnerTopicActivationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerTopicActivationState"/>. </summary>
        public static implicit operator PartnerTopicActivationState(string value) => new PartnerTopicActivationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerTopicActivationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerTopicActivationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
