// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the partner registration. </summary>
    public readonly partial struct PartnerRegistrationProvisioningState : IEquatable<PartnerRegistrationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerRegistrationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerRegistrationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static PartnerRegistrationProvisioningState Creating { get; } = new PartnerRegistrationProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static PartnerRegistrationProvisioningState Updating { get; } = new PartnerRegistrationProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static PartnerRegistrationProvisioningState Deleting { get; } = new PartnerRegistrationProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static PartnerRegistrationProvisioningState Succeeded { get; } = new PartnerRegistrationProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static PartnerRegistrationProvisioningState Canceled { get; } = new PartnerRegistrationProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static PartnerRegistrationProvisioningState Failed { get; } = new PartnerRegistrationProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="PartnerRegistrationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PartnerRegistrationProvisioningState left, PartnerRegistrationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerRegistrationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PartnerRegistrationProvisioningState left, PartnerRegistrationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerRegistrationProvisioningState"/>. </summary>
        public static implicit operator PartnerRegistrationProvisioningState(string value) => new PartnerRegistrationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerRegistrationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerRegistrationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
