// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The type of the event channel which represents the direction flow of events. </summary>
    public readonly partial struct PartnerNamespaceChannelType : IEquatable<PartnerNamespaceChannelType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerNamespaceChannelType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerNamespaceChannelType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PartnerTopicValue = "PartnerTopic";
        private const string PartnerDestinationValue = "PartnerDestination";

        /// <summary> PartnerTopic. </summary>
        public static PartnerNamespaceChannelType PartnerTopic { get; } = new PartnerNamespaceChannelType(PartnerTopicValue);
        /// <summary> PartnerDestination. </summary>
        public static PartnerNamespaceChannelType PartnerDestination { get; } = new PartnerNamespaceChannelType(PartnerDestinationValue);
        /// <summary> Determines if two <see cref="PartnerNamespaceChannelType"/> values are the same. </summary>
        public static bool operator ==(PartnerNamespaceChannelType left, PartnerNamespaceChannelType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerNamespaceChannelType"/> values are not the same. </summary>
        public static bool operator !=(PartnerNamespaceChannelType left, PartnerNamespaceChannelType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerNamespaceChannelType"/>. </summary>
        public static implicit operator PartnerNamespaceChannelType(string value) => new PartnerNamespaceChannelType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerNamespaceChannelType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerNamespaceChannelType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
