// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the channel. </summary>
    public readonly partial struct PartnerNamespaceChannelProvisioningState : IEquatable<PartnerNamespaceChannelProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerNamespaceChannelProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerNamespaceChannelProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string IdleDueToMirroredPartnerTopicDeletionValue = "IdleDueToMirroredPartnerTopicDeletion";
        private const string IdleDueToMirroredPartnerDestinationDeletionValue = "IdleDueToMirroredPartnerDestinationDeletion";

        /// <summary> Creating. </summary>
        public static PartnerNamespaceChannelProvisioningState Creating { get; } = new PartnerNamespaceChannelProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static PartnerNamespaceChannelProvisioningState Updating { get; } = new PartnerNamespaceChannelProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static PartnerNamespaceChannelProvisioningState Deleting { get; } = new PartnerNamespaceChannelProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static PartnerNamespaceChannelProvisioningState Succeeded { get; } = new PartnerNamespaceChannelProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static PartnerNamespaceChannelProvisioningState Canceled { get; } = new PartnerNamespaceChannelProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static PartnerNamespaceChannelProvisioningState Failed { get; } = new PartnerNamespaceChannelProvisioningState(FailedValue);
        /// <summary> IdleDueToMirroredPartnerTopicDeletion. </summary>
        public static PartnerNamespaceChannelProvisioningState IdleDueToMirroredPartnerTopicDeletion { get; } = new PartnerNamespaceChannelProvisioningState(IdleDueToMirroredPartnerTopicDeletionValue);
        /// <summary> IdleDueToMirroredPartnerDestinationDeletion. </summary>
        public static PartnerNamespaceChannelProvisioningState IdleDueToMirroredPartnerDestinationDeletion { get; } = new PartnerNamespaceChannelProvisioningState(IdleDueToMirroredPartnerDestinationDeletionValue);
        /// <summary> Determines if two <see cref="PartnerNamespaceChannelProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PartnerNamespaceChannelProvisioningState left, PartnerNamespaceChannelProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerNamespaceChannelProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PartnerNamespaceChannelProvisioningState left, PartnerNamespaceChannelProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerNamespaceChannelProvisioningState"/>. </summary>
        public static implicit operator PartnerNamespaceChannelProvisioningState(string value) => new PartnerNamespaceChannelProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerNamespaceChannelProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerNamespaceChannelProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
