// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the partner configuration. </summary>
    public readonly partial struct PartnerConfigurationProvisioningState : IEquatable<PartnerConfigurationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerConfigurationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerConfigurationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static PartnerConfigurationProvisioningState Creating { get; } = new PartnerConfigurationProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static PartnerConfigurationProvisioningState Updating { get; } = new PartnerConfigurationProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static PartnerConfigurationProvisioningState Deleting { get; } = new PartnerConfigurationProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static PartnerConfigurationProvisioningState Succeeded { get; } = new PartnerConfigurationProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static PartnerConfigurationProvisioningState Canceled { get; } = new PartnerConfigurationProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static PartnerConfigurationProvisioningState Failed { get; } = new PartnerConfigurationProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="PartnerConfigurationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PartnerConfigurationProvisioningState left, PartnerConfigurationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerConfigurationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PartnerConfigurationProvisioningState left, PartnerConfigurationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerConfigurationProvisioningState"/>. </summary>
        public static implicit operator PartnerConfigurationProvisioningState(string value) => new PartnerConfigurationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerConfigurationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerConfigurationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
