// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The partner authorization details. </summary>
    public partial class PartnerAuthorization
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerAuthorization"/>. </summary>
        public PartnerAuthorization()
        {
            AuthorizedPartnersList = new ChangeTrackingList<EventGridPartnerContent>();
        }

        /// <summary> Initializes a new instance of <see cref="PartnerAuthorization"/>. </summary>
        /// <param name="defaultMaximumExpirationTimeInDays">
        /// Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
        /// not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
        /// </param>
        /// <param name="authorizedPartnersList"> The list of authorized partners. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerAuthorization(int? defaultMaximumExpirationTimeInDays, IList<EventGridPartnerContent> authorizedPartnersList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DefaultMaximumExpirationTimeInDays = defaultMaximumExpirationTimeInDays;
            AuthorizedPartnersList = authorizedPartnersList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
        /// not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
        /// </summary>
        [WirePath("defaultMaximumExpirationTimeInDays")]
        public int? DefaultMaximumExpirationTimeInDays { get; set; }
        /// <summary> The list of authorized partners. </summary>
        [WirePath("authorizedPartnersList")]
        public IList<EventGridPartnerContent> AuthorizedPartnersList { get; }
    }
}
